<?xml version="1.0" encoding="UTF-8"?>
<!-- 
####################################################################################
#  XSL name : section0
#  Version : R2.0.9.S02                                        
#  Intermediate release number : 018-20170214                                      
#  Last update : 16/11/2016                                                            
####################################################################################
 -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" xmlns:mi="http://www.w3.org/2001/XMLSchema-instance" xmlns:ted1="http://formex.publications.europa.eu/ted/schema/reception/R2.0.9.S01" xmlns:ted2="ted/R2.0.9.S02/reception" exclude-result-prefixes="ted1 ted2">
	<!---->
	<xsl:template match="@mi:schemaLocation" mode="R998">
		<xsl:if test="not(matches(normalize-space(string()),'^([^\s]+&#x20;[^\s]+\.xsd(&#x20;[^\s]+&#x20;[^\s]+\.xsd)*)$'))">
			<xsl:variable name="attr" select="concat('xsi:schemaLocation with value ', &quot;'&quot;, string(), &quot;'&quot;)"/>
			<xsl:call-template name="msg">
				<xsl:with-param name="rule" select="'R998'"/>
				<xsl:with-param name="content" select="$attr"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<!---->
	<xsl:template match="*" mode="R100">
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R100'"/>
			<xsl:with-param name="content" select="''"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*:FORM_SECTION" mode="R101">
		<xsl:if test=".//*[@CURRENCY != .//*/@CURRENCY[1]]">
			<xsl:call-template name="msg">
				<xsl:with-param name="rule" select="'R101'"/>
				<xsl:with-param name="content" select="''"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<!---->
	<xsl:template match="*:E_MAIL" mode="R102">
		<xsl:variable name="ele">'<xsl:value-of select="normalize-space(text())"/>'</xsl:variable>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R102'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM]" mode="R104">
		<xsl:if test=".//*:OBJECT_CONTRACT[position()!=@ITEM] ">
			<xsl:variable name="ele" select="'OBJECT_CONTRACT/@ITEM'"/>
			<xsl:call-template name="msg">
				<xsl:with-param name="rule" select="'R104'"/>
				<xsl:with-param name="content" select="$ele"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test=".//*:OBJECT_CONTRACT[child::*:OBJECT_DESCR[position()!=@ITEM]] ">
			<xsl:variable name="ele" select="'OBJECT_DESCR/@ITEM'"/>
			<xsl:call-template name="msg">
				<xsl:with-param name="rule" select="'R104'"/>
				<xsl:with-param name="content" select="$ele"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test=".//*:AWARD_CONTRACT[position()!=@ITEM]">
			<xsl:variable name="ele" select="'AWARD_CONTRACT/@ITEM'"/>
			<xsl:call-template name="msg">
				<xsl:with-param name="rule" select="'R104'"/>
				<xsl:with-param name="content" select="$ele"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<!---->
	<xsl:template match="*:USER_E_MAIL|*:E_MAIL" mode="R105">
		<xsl:if test="(string-length(normalize-space(.))&gt; 200  ) or (string-length(normalize-space(.))&gt; 0 and not(matches(normalize-space(.),'^[A-Za-z0-9!#$%&amp;''*+/=?_-]+(\.[A-Za-z0-9!#$%&amp;''*+/=?_-]+)*@([A-Za-z0-9]([A-Za-z0-9-]*[A-Za-z0-9])?\.)+([A-Za-z]{2,})$')))">
			<xsl:call-template name="msg">
				<xsl:with-param name="rule" select="'R105'"/>
				<xsl:with-param name="content" select="concat(local-name(.),' with value ', &quot;'&quot;, normalize-space(./text()), &quot;'&quot;)"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<!---->
	<xsl:template match="*[*:DATE_END/number(replace(text(),'-','')) &lt;= *:DATE_START/number(replace(text(),'-',''))]" mode="R106">
		<xsl:variable name="ele" select="concat(local-name(parent::*),'[',parent::*/@ITEM,']/',local-name(),'[',@ITEM,'][DATE_START=',*:DATE_START/text(),', ','DATE_END=',*:DATE_END/text(),']')"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R106'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*:NOTICE_NUMBER_OJ" mode="R107">
		<xsl:choose>
			<xsl:when test="matches(./text(),'^(20|19)\d{2}/S (((00)?[1-9])|([0]?[1-9][0-9])|(1[0-9][0-9])|(2[0-5][0-9]))-\d{6}$')"/>
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R107'"/>
					<xsl:with-param name="content" select="concat(local-name(.),' with value ',current())"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM]" mode="R115">
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R115'"/>
			<xsl:with-param name="content" select="concat('Total CPV: ',count(.//*[matches(local-name(),'CPV')][attribute::CODE]/@CODE),' / Unique CPV: ',count(distinct-values(.//*[matches(local-name(),'CPV')][attribute::CODE]/@CODE)))"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM]" mode="R116">
		<xsl:if test=".//*:LOT_DIVISION">
			<xsl:call-template name="msg">
				<xsl:with-param name="rule" select="'R116'"/>
				<xsl:with-param name="content" select="concat('Number of LOT: ',count(.//*:OBJECT_DESCR))"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<!---->
	<xsl:template match="*:VAL_RANGE_OBJECT|*:VAL_RANGE_TOTAL" mode="R158">
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM]//*:NOTICE/@*[not(matches(.,'AWARD'))]"/>
			<xsl:when test="number(*:LOW/text())>0 and number(*:HIGH/text())&gt;=number(*:LOW/text())"/>
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R158'"/>
					<xsl:with-param name="content" select="concat(local-name(),'[HIGH=',string(./*:HIGH),', LOW=',string(./*:LOW),']')"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*:DATE_DISPATCH_NOTICE" mode="R251">
		<xsl:choose>
			<xsl:when test="number(substring-before(//*:IDENTIFICATION/*:NO_DOC_EXT/text(),'-'))=number(substring-before(./text(),'-'))"/>
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R251'"/>
					<xsl:with-param name="content" select="concat('NO_DOC_EXT=',&quot;'&quot;,//*:IDENTIFICATION/*:NO_DOC_EXT/text(),&quot;'&quot;,', DATE_DISPATCH_NOTICE=',&quot;'&quot;,text(),&quot;'&quot;)"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="R251"/>
	</xsl:template>
	<!---->
	<xsl:template match="*:FORM_SECTION//*:NO_DOC_EXT[compare(./text(),//*:SENDER//*:NO_DOC_EXT/text())=0]" mode="R113">
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM]//*:NOTICE/@*[not(matches(.,'AWARD'))]"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat(local-name(ancestor::*:F14_2014|ancestor::*:AWARD_CONTRACT),'[',ancestor::*:AWARD_CONTRACT/@ITEM,']//NO_DOC_EXT=',./text(),', SENDER/IDENTIFICATION/NO_DOC_EXT=',//*:SENDER//*:NO_DOC_EXT/text())"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R113'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
